package parser;

/**
 * Factory for S grammar non-terminal objects.
 */
public class SFact extends ATVFactory {
    /**
     * Factory for T grammar non-terminals.
     */
    private TFact _tFact;

    /**
     * Factory for P grammar terminals.
     */
    private PFact _pFact;

    /**
     * Constructor for the S factory,
     *
     * @param tkz   tokenizer to use
     * @param tFact factory for T non-terminals
     * @param pFact factory for P non-terminals
     */
    public SFact(ITokenizer tkz, TFact tFact, PFact pFact) {
        super(tkz);
        _tFact = tFact;
        _pFact = pFact;

    }

    /**
     * Make a token visitor to parse an S non-terminal.
     *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        return _tFact.makeChainedVisitor(_pFact.makeVisitor());
    }

    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     *
     * @param successor visitor to serve as successor in the chain
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        return _tFact.makeChainedVisitor(_pFact.makeChainedVisitor(successor));
    }
}

